﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using ext = Ext.Net;
using Newtonsoft;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;

[ext.DirectMethodProxyID(Alias = "INSTRUMENTS")]

public partial class ucInstrumentList : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    /// <summary>
    /// Page Load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    [ext.DirectMethod(ShowMask = true, Msg = "Please wait")]
    /// <summary>
    /// Initialize the Instrument List user control
    /// </summary>
    public void InitializeControl()
    {
        RenderAppointmentsTree();
    }

    /// <summary>
    /// populate the tree with the appointments and instruments
    /// </summary>
    protected void RenderAppointmentsTree() {
        //add nodes to the tree
        var nodes = GetPWEventNodes(String.Empty);
        treePatAppointments.Root.Add(nodes[0]);
    }

    /// <summary>
    /// Gets all pathwways event nodes associated to a patient
    /// </summary>
    /// <returns></returns>
    protected Ext.Net.NodeCollection GetPWEventNodes(string strSelectedPW)
    {
        ext.NodeCollection nodes = new ext.NodeCollection();
        Ext.Net.Node nRoot = new ext.Node() { Expanded = true, EmptyChildren = true };
        CTxTree txtree = new CTxTree(BaseMstr);
        txtree.RenderPWEvents(strSelectedPW, nRoot);
        nodes.Add(nRoot);
        return nodes;
    }
     
}